// tailwind.config.ts
import type { Config } from 'tailwindcss';

const config: Config = {
  content: [
    './app/**/*.{js,ts,jsx,tsx,mdx}',
    './components/**/*.{js,ts,jsx,tsx,mdx}',
  ],
  theme: {
    extend: {
      colors: {
        // Palet warna yang lebih kurasi
        'bali-primary': '#0F6764', // Deep Teal / Dark Cyan
        'bali-secondary': '#E0E7E9', // Soft Gray/Blue-ish White
        'bali-accent': '#FFD700', // Gold (untuk highlight)
        'bali-dark': '#1A202C', // Very Dark Blue-ish Gray
        'bali-light': '#F7FAFC', // Near-white
        'bali-text-dark': '#2D3748', // Dark Grayish Blue for body text
        'bali-text-light': '#FFFFFF', // Pure White

        // Warna yang digunakan sebelumnya (jika masih diperlukan)
        'primary-color': 'rgb(15, 103, 100)',
        'secondary-color': 'rgb(240, 240, 240)',
        'accent-color': 'rgb(255, 193, 7)',
        'dark-teal': '#0d8a86',
      },
      fontFamily: {
        // Kombinasi font untuk judul dan body
        heading: ['Playfair Display', 'serif'], // Font serif untuk kesan elegan
        body: ['Inter', 'sans-serif'],        // Font sans-serif untuk readability
      },
      backgroundImage: {
        // Jika ada background custom
      },
      // Penyesuaian ukuran dan spasi yang lebih granular
      spacing: {
        '128': '32rem',
        '144': '36rem',
      },
      borderRadius: {
        '4xl': '2rem',
        '5xl': '2.5rem',
      },
    },
  },
  plugins: [],
};

export default config;