'use client';

import { motion, useInView } from 'framer-motion';
import { useRef } from 'react';
import SectionTitle from './SectionTitle';

// Data testimonial
const testimonials = [
    {
        quote: "Our Bali trip was simply magical! Every detail was flawlessly handled, from luxurious stays to captivating cultural tours. Highly recommended for a stress-free and memorable adventure.",
        name: "Ayu Lestari",
        title: "Solo Explorer"
    },
    {
        quote: "An unforgettable family holiday! The kids absolutely loved the activities, and we felt truly cared for. This team knows how to make dreams come true.",
        name: "Budi Santoso",
        title: "Family Vacationer"
    },
    {
        quote: "Sangat mudah merencanakan perjalanan dengan mereka. Semua detail diurus dengan sempurna, membuat perjalanan saya bebas stres.",
        name: "Dewi Chandra",
        title: "Honeymooner"
    },
    {
        quote: "Professional, attentive, and passionate about Bali. They truly listen to your desires and craft an experience that resonates. Couldn't ask for more.",
        name: "Putu Ari",
        title: "Adventure Seeker"
    },
];

const Testimonials = () => {
    const ref = useRef(null);
    // Animasi dipicu saat elemen 30% masuk viewport, hanya sekali.
    const isInView = useInView(ref, { once: true, amount: 0.3 });

    // Varian untuk kontainer testimonial
    const containerVariants = {
        hidden: { opacity: 0 },
        visible: {
            opacity: 1,
            transition: {
                staggerChildren: 0.15, // Animasi anak-anak secara berurutan
            },
        },
    };

    // Varian untuk setiap item testimonial
    const itemVariants = {
        hidden: { opacity: 0, y: 60, scale: 0.95 },
        visible: { opacity: 1, y: 0, scale: 1, transition: { duration: 0.7, ease: "easeOut" } },
    };

    return (
        <motion.section
            id="testimonials"
            ref={ref} // Referensi untuk useInView
            // min-h agar tidak terlalu pendek
            className="p-10 md:p-24 bg-bali-primary text-bali-text-light text-center min-h-[70vh] flex flex-col justify-center items-center overflow-hidden"
            variants={containerVariants}
            initial="hidden"
            animate={isInView ? "visible" : "hidden"} // Animasi hanya jika elemen terlihat
        >
            {/* Komponen SectionTitle untuk judul section Testimonial */}
            <SectionTitle
                supertitle="Voices of Delight"
                title="What Our Travelers Share"
                subtitle="Read inspiring stories from those who've experienced Bali's magic with us."
                textColor="text-bali-text-light" // Ubah warna teks judul menjadi light
                supertitleColor="text-bali-accent" // Ubah warna supertitle menjadi accent
            />

            {/* Grid Testimonial */}
            <motion.div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8 max-w-7xl mx-auto">
                {testimonials.map((testimonial, index) => (
                    <motion.div
                        key={index}
                        className="bg-bali-light text-bali-text-dark p-8 rounded-xl shadow-xl flex flex-col justify-between h-full transform transition-transform duration-300 hover:scale-[1.02] hover:shadow-2xl"
                        variants={itemVariants} // Varian animasi untuk setiap testimonial
                    >
                        {/* Icon kutipan */}
                        <svg className="w-12 h-12 text-bali-accent mb-4 mx-auto" fill="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9.25 10c.828 0 1.5.672 1.5 1.5s-.672 1.5-1.5 1.5c-.828 0-1.5-.672-1.5-1.5s.672-1.5 1.5-1.5zm5.5 0c.828 0 1.5.672 1.5 1.5s-.672 1.5-1.5 1.5c-.828 0-1.5-.672-1.5-1.5s.672-1.5 1.5-1.5zM12 2C6.477 2 2 6.477 2 12s4.477 10 10 10 10-4.477 10-10S17.523 2 12 2zm0 18c-4.411 0-8-3.589-8-8s3.589-8 8-8 8 3.589 8 8-3.589 8-8 8zM9.5 14.5c-1.657 0-3 1.343-3 3h-1c0-2.206 1.794-4 4-4s4 1.794 4 4h-1c0-1.657-1.343-3-3-3zm5.5 0c-1.657 0-3 1.343-3 3h-1c0-2.206 1.794-4 4-4s4 1.794 4 4h-1c0-1.657-1.343-3-3-3z" />
                        </svg>
                        <p className="text-lg italic mb-6 leading-relaxed flex-grow">"{testimonial.quote}"</p>
                        <div className="text-left border-t pt-4 border-gray-200">
                            <p className="font-bold text-bali-primary text-xl font-heading">{testimonial.name}</p>
                            <p className="text-sm text-gray-600">{testimonial.title}</p>
                        </div>
                    </motion.div>
                ))}
            </motion.div>
        </motion.section>
    );
};

export default Testimonials;