'use client'; // Client Component karena menggunakan hooks Framer Motion

import { motion, useInView } from 'framer-motion';
import { useRef } from 'react';

interface SectionTitleProps {
    supertitle?: string; // Judul kecil di atas judul utama
    title: string;       // Judul utama section
    subtitle?: string;  // Deskripsi di bawah judul utama
    textColor?: string; // Opsional: warna teks judul utama dan subtitle
    supertitleColor?: string; // Opsional: warna teks supertitle
}

const SectionTitle = ({ supertitle, title, subtitle, textColor = 'text-bali-dark', supertitleColor = 'text-bali-primary' }: SectionTitleProps) => {
    const ref = useRef(null);
    // useInView: Trigger animasi saat 50% elemen masuk viewport, hanya sekali
    const isInView = useInView(ref, { once: true, amount: 0.5 });

    const containerVariants = {
        hidden: { opacity: 0, y: 30 },
        visible: {
            opacity: 1,
            y: 0,
            transition: {
                duration: 0.6,
                staggerChildren: 0.1, // Animasi anak-anak secara berurutan
                ease: "easeOut", // Easing standar
            },
        },
    };

    const itemVariants = {
        hidden: { opacity: 0, y: 30 },
        visible: { opacity: 1, y: 0, transition: { duration: 0.5, ease: "easeOut" } },
    };

    return (
        <motion.div
            ref={ref}
            className="text-center mb-12 md:mb-20 max-w-4xl mx-auto px-4" // Tambah px-4 untuk padding di mobile
            variants={containerVariants}
            initial="hidden"
            animate={isInView ? "visible" : "hidden"}
        >
            {supertitle && (
                <motion.p className={`${supertitleColor} text-lg font-semibold mb-2 uppercase tracking-wider`} variants={itemVariants}>
                    {supertitle}
                </motion.p>
            )}
            <motion.h2 className={`${textColor} text-4xl md:text-6xl font-bold font-heading leading-tight mb-4`} variants={itemVariants}>
                {title}
            </motion.h2>
            {subtitle && (
                <motion.p className={`${textColor} text-lg md:text-xl leading-relaxed opacity-90`} variants={itemVariants}>
                    {subtitle}
                </motion.p>
            )}
        </motion.div>
    );
};

export default SectionTitle;