'use client'; // Client Component jika ada interaktivitas (misalnya social media hover, meskipun di sini tidak ada state)

import Link from 'next/link';

const Footer = () => {
    return (
        <footer className="bg-bali-dark text-bali-light p-10 md:p-20 text-center relative overflow-hidden">
            {/* Wave pattern (opsional, bisa diganti dengan SVG atau dihapus) */}
            <div className="absolute top-0 left-0 w-full h-12 bg-gradient-to-t from-bali-primary to-transparent pointer-events-none"></div>

            <div className="max-w-7xl mx-auto grid grid-cols-1 md:grid-cols-4 gap-12 md:gap-8 text-left"> {/* text-left untuk alignment */}
                {/* Kolom 1: Logo & Deskripsi Singkat */}
                <div className="md:col-span-1">
                    <Link href="/" className="text-bali-light text-3xl font-bold font-heading mb-4 block hover:text-bali-accent transition-colors">
                        Bali.ID
                    </Link>
                    <p className="text-bali-secondary text-sm leading-relaxed">
                        Your trusted gateway to the enchanting wonders of Bali. We craft bespoke journeys for unforgettable experiences.
                    </p>
                </div>

                {/* Kolom 2: Quick Links */}
                <div>
                    <h4 className="text-xl font-semibold font-heading mb-4 text-bali-accent">Quick Links</h4>
                    <ul className="space-y-3 text-bali-secondary">
                        <li><a href="#about" onClick={(e) => { e.preventDefault(); document.getElementById('about')?.scrollIntoView({ behavior: 'smooth' }); }} className="hover:text-bali-light transition-colors">About Us</a></li>
                        <li><a href="#discover" onClick={(e) => { e.preventDefault(); document.getElementById('discover')?.scrollIntoView({ behavior: 'smooth' }); }} className="hover:text-bali-light transition-colors">Destinations</a></li>
                        <li><a href="#testimonials" onClick={(e) => { e.preventDefault(); document.getElementById('testimonials')?.scrollIntoView({ behavior: 'smooth' }); }} className="hover:text-bali-light transition-colors">Testimonials</a></li>
                        <li><Link href="/privacy-policy" className="hover:text-bali-light transition-colors">Privacy Policy</Link></li> {/* Contoh link ke halaman lain */}
                    </ul>
                </div>

                {/* Kolom 3: Services */}
                <div>
                    <h4 className="text-xl font-semibold font-heading mb-4 text-bali-accent">Our Services</h4>
                    <ul className="space-y-3 text-bali-secondary">
                        <li><a href="#" className="hover:text-bali-light transition-colors">Custom Tours</a></li>
                        <li><a href="#" className="hover:text-bali-light transition-colors">Group Packages</a></li>
                        <li><a href="#" className="hover:text-bali-light transition-colors">Luxury Retreats</a></li>
                        <li><a href="#" className="hover:text-bali-light transition-colors">Adventure Travel</a></li>
                    </ul>
                </div>

                {/* Kolom 4: Contact Info & Social */}
                <div>
                    <h4 className="text-xl font-semibold font-heading mb-4 text-bali-accent">Get In Touch</h4>
                    <p className="text-bali-secondary mb-3">Jl. Pesona Bali No. 88, Denpasar, Bali</p>
                    <p className="text-bali-secondary mb-3">Phone: +62 812 3456 7890</p>
                    <p className="text-bali-secondary mb-6">Email: info@balitravel.com</p>
                    <div className="flex gap-4">
                        {/* Social Media Icons (contoh, bisa diganti dengan SVG asli atau library ikon) */}
                        {/* Untuk ikon font awesome, Anda perlu mengimpor CDN di app/layout.tsx atau menginstal paket */}
                        <a href="#" className="text-bali-secondary hover:text-bali-light transition-colors text-2xl" aria-label="Facebook"><i className="fab fa-facebook-f"></i></a>
                        <a href="#" className="text-bali-secondary hover:text-bali-light transition-colors text-2xl" aria-label="Instagram"><i className="fab fa-instagram"></i></a>
                        <a href="#" className="text-bali-secondary hover:text-bali-light transition-colors text-2xl" aria-label="Twitter"><i className="fab fa-twitter"></i></a>
                    </div>
                </div>
            </div>

            <div className="border-t border-gray-700 mt-16 pt-8 text-bali-secondary text-sm text-center">
                &copy; {new Date().getFullYear()} Bali.ID. All rights reserved. Crafted with ❤️ in Bali.
            </div>
        </footer>
    );
};

export default Footer;