'use client';

import { motion, useInView } from 'framer-motion';
import { useRef } from 'react';
import Image from 'next/image';
import SectionTitle from './SectionTitle';

// Data kartu destinasi
const discoverCards = [
    {
        image: "/images/tirta-empul.jpg",
        title: "Pura Tirta Empul",
        description: "Experience the sacred purification ritual at this ancient Hindu temple, known for its holy spring water and serene ambiance.",
    },
    {
        image: "/images/tanah-lot-card.jpeg",
        title: "Pura Tanah Lot",
        description: "Witness breathtaking sunsets at this iconic sea temple perched on a rock formation, a spiritual and photographic marvel.",
    },
    {
        image: "/images/padang-padang.jpg",
        title: "Padang Padang Beach",
        description: "Discover a secluded paradise, famous for its stunning white sands, crystal-clear waters, and world-class surf breaks.",
    },
    {
        image: "/images/monkey-forest.jpg",
        title: "Ubud Monkey Forest",
        description: "Explore a lush natural sanctuary home to hundreds of playful monkeys and ancient Hindu temples, a unique cultural experience.",
    },
    {
        image: "/images/rice-terrace.jpeg",
        title: "Tegalalang Rice Terraces",
        description: "Marvel at the stunning emerald-green terraced rice fields, an iconic landscape offering panoramic views and cultural insights.",
    },
    {
        image: "/images/uluwatu-temple.jpg",
        title: "Pura Uluwatu",
        description: "Perched atop a towering cliff, this majestic sea temple offers dramatic ocean views and hosts the captivating Kecak fire dance at sunset.",
    },
];

const Discover = () => {
    const ref = useRef(null);
    const isInView = useInView(ref, { once: true, amount: 0.2 });

    // Varian untuk kontainer kartu (staggering children)
    const cardContainerVariants = {
        hidden: { opacity: 0 },
        visible: {
            opacity: 1,
            transition: {
                staggerChildren: 0.08, // Animasi anak-anak secara berurutan
            },
        },
    };

    // Varian untuk setiap kartu
    const cardItemVariants = {
        hidden: { opacity: 0, y: 60, scale: 0.9 },
        visible: { opacity: 1, y: 0, scale: 1, transition: { duration: 0.6, ease: "easeOut" } },
    };

    return (
        <motion.section
            id="discover"
            ref={ref} // Referensi untuk useInView
            className="p-10 md:p-24 bg-bali-secondary text-bali-text-dark min-h-screen flex flex-col justify-center items-center overflow-hidden"
            initial="hidden"
            animate={isInView ? "visible" : "hidden"}
            variants={{
                hidden: { opacity: 0 },
                visible: { opacity: 1, transition: { duration: 0.5 } }
            }}
        >
            {/* Komponen SectionTitle untuk judul section Discover */}
            <SectionTitle
                supertitle="Our Top Picks"
                title="Unforgettable Destinations"
                subtitle="Explore our curated selection of Bali's most enchanting and iconic places, designed to inspire your next adventure."
            />

            {/* Grid kartu destinasi */}
            <motion.div
                className="gallery grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8 md:gap-10 max-w-7xl mx-auto"
                variants={cardContainerVariants}
            >
                {discoverCards.map((card, index) => (
                    <motion.div
                        key={index}
                        className="relative bg-white rounded-xl shadow-xl overflow-hidden group cursor-pointer
                       transform transition-all duration-300 hover:scale-[1.03] hover:shadow-2xl" // Efek hover pada kartu
                        variants={cardItemVariants} // Varian animasi untuk setiap kartu
                        whileHover={{ scale: 1.03 }} // Animasi tambahan saat hover
                    >
                        {/* Gambar kartu, dioptimalkan dengan next/image */}
                        <div className="relative w-full h-64 overflow-hidden">
                            <Image src={card.image} alt={card.title} fill className="object-cover transition-transform duration-500 group-hover:scale-110" sizes="(max-width: 768px) 100vw, 33vw" />
                        </div>
                        {/* Konten teks kartu */}
                        <div className="p-6 text-left">
                            <h3 className="text-2xl font-semibold font-heading mb-2 text-bali-primary">{card.title}</h3>
                            <p className="text-sm text-bali-text-dark line-clamp-3">{card.description}</p>
                            {/* Tombol Learn More dengan animasi panah */}
                            <motion.button
                                className="mt-4 text-bali-primary hover:text-bali-dark font-semibold flex items-center group-hover:translate-x-1 transition-transform"
                                whileHover={{ x: 5 }} // Animasi panah saat hover
                            >
                                Learn More
                                <svg className="ml-2 w-4 h-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fillRule="evenodd" d="M10.293 15.707a1 1 0 010-1.414L14.586 10l-4.293-4.293a1 1 0 111.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clipRule="evenodd"></path><path fillRule="evenodd" d="M4.293 15.707a1 1 0 010-1.414L8.586 10 4.293 5.707a1 1 0 011.414-1.414l5 5a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0z" clipRule="evenodd"></path></svg>
                            </motion.button>
                        </div>
                    </motion.div>
                ))}
            </motion.div>
        </motion.section>
    );
};

export default Discover;