'use client';

import { motion, useInView } from 'framer-motion';
import { useRef } from 'react';
import Link from 'next/link';
import SectionTitle from './SectionTitle';

const Contact = () => {
    const ref = useRef(null);
    // Animasi dipicu saat elemen 40% masuk viewport, hanya sekali.
    const isInView = useInView(ref, { once: true, amount: 0.4 });

    // Varian untuk kontainer
    const containerVariants = {
        hidden: { opacity: 0, y: 50 },
        visible: {
            opacity: 1,
            y: 0,
            transition: {
                duration: 0.8,
                staggerChildren: 0.1,
                ease: "easeOut" // Easing standar
            },
        },
    };

    // Varian untuk item-item di dalamnya
    const itemVariants = {
        hidden: { opacity: 0, y: 40 },
        visible: { opacity: 1, y: 0, transition: { duration: 0.6, ease: "easeOut" } },
    };

    return (
        <motion.section
            id="contact"
            ref={ref} // Referensi untuk useInView
            className="p-10 md:p-24 bg-gradient-to-br from-bali-primary to-bali-dark text-bali-light text-center min-h-[60vh] flex flex-col justify-center items-center relative overflow-hidden"
            variants={containerVariants}
            initial="hidden"
            animate={isInView ? "visible" : "hidden"} // Animasi hanya jika elemen terlihat
        >
            {/* Elemen dekoratif latar belakang (glassmorphism/blur effect) */}
            <motion.div
                className="absolute w-64 h-64 bg-bali-accent rounded-full opacity-10 blur-3xl top-10 left-10"
                animate={{ y: [0, 20, 0], x: [0, 20, 0] }} // Animasi bergerak
                transition={{ repeat: Infinity, duration: 8, ease: "easeInOut" }}
            ></motion.div>
            <motion.div
                className="absolute w-96 h-96 bg-bali-secondary rounded-full opacity-5 blur-3xl bottom-10 right-10"
                animate={{ y: [0, -30, 0], x: [0, -30, 0] }} // Animasi bergerak
                transition={{ repeat: Infinity, duration: 10, ease: "easeInOut", delay: 1 }}
            ></motion.div>

            <div className="relative z-10 max-w-4xl mx-auto">
                {/* Komponen SectionTitle untuk judul section Contact */}
                <SectionTitle
                    supertitle="Connect With Us"
                    title="Ready to Start Your Bali Adventure?"
                    subtitle="Let's make your dream trip a reality. Contact us today for a personalized itinerary and unforgettable memories."
                    textColor="text-bali-light" // Ubah warna teks judul menjadi light
                    supertitleColor="text-bali-accent" // Ubah warna supertitle menjadi accent
                />

                {/* Tombol Call to Action */}
                <motion.div className="flex flex-col sm:flex-row justify-center gap-6 mt-12" variants={containerVariants}>
                    <motion.a
                        href="tel:+6281234567890"
                        className="btn-primary text-bali-primary bg-bali-accent hover:bg-opacity-90 px-10 py-4 text-xl"
                        variants={itemVariants}
                    >
                        Call Us Now
                    </motion.a>
                    <motion.a
                        href="mailto:info@balitravel.com"
                        className="btn-secondary border-bali-light text-bali-light hover:bg-bali-light hover:text-bali-primary px-10 py-4 text-xl"
                        variants={itemVariants}
                    >
                        Email Us
                    </motion.a>
                </motion.div>
            </div>
        </motion.section>
    );
};

export default Contact;