'use client'; // Menandakan bahwa ini adalah Client Component

import { motion, useInView } from 'framer-motion';
import { useRef } from 'react';
import Image from 'next/image'; // Menggunakan komponen Image dari Next.js untuk optimasi
import Link from 'next/link';   // Menggunakan Link dari Next.js untuk navigasi (untuk anchor scroll)
import SectionTitle from './SectionTitle'; // Menggunakan komponen SectionTitle

const About = () => {
    const ref = useRef(null);
    // Animasi dipicu saat elemen 30% masuk viewport, hanya sekali.
    const isInView = useInView(ref, { once: true, amount: 0.3 });

    // Varian untuk kontainer dan item-item di dalamnya
    const containerVariants = {
        hidden: { opacity: 0, y: 50 },
        visible: {
            opacity: 1,
            y: 0,
            transition: {
                duration: 0.8,
                staggerChildren: 0.1, // Anak-anak animasi secara berurutan
                ease: "easeOut" // Easing standar
            },
        },
    };

    const itemVariants = {
        hidden: { opacity: 0, y: 40, scale: 0.95 },
        visible: { opacity: 1, y: 0, scale: 1, transition: { duration: 0.7, ease: "easeOut" } },
    };

    // Varian animasi yang DITINGKATKAN untuk gambar di About section
    const imageEntryVariants = {
        hidden: { opacity: 0, scale: 0.7, rotate: -10, y: 50 }, // Mulai dari kecil, berputar, dan dari bawah
        visible: {
            opacity: 1,
            scale: 1,
            rotate: 0,
            y: 0,
            transition: {
                duration: 0.9,
                ease: [0.25, 0.46, 0.45, 0.94], // Easing custom cubic-bezier untuk efek masuk yang lebih dinamis
            },
        },
    };

    return (
        <motion.section
            id="about"
            ref={ref} // Referensi untuk useInView
            // min-h-screen memastikan section setidaknya satu layar penuh
            className="relative p-10 md:p-24 bg-bali-light text-bali-text-dark min-h-screen flex flex-col justify-center items-center overflow-hidden"
            variants={containerVariants}
            initial="hidden"
            animate={isInView ? "visible" : "hidden"} // Animasi hanya jika elemen terlihat
        >
            {/* Pattern latar belakang (jika ada file pattern-bali.png) */}
            <div className="absolute inset-0 bg-[url('/images/pattern-bali.png')] opacity-5 pointer-events-none z-0"></div>

            <div className="relative z-10 w-full max-w-7xl mx-auto">
                {/* Komponen SectionTitle untuk judul section */}
                <SectionTitle
                    supertitle="Discover More"
                    title="Unveiling The Soul of Bali"
                    subtitle="From ancient temples to lush rice paddies, immerse yourself in the vibrant culture and breathtaking landscapes."
                />

                <div className="grid grid-cols-1 md:grid-cols-2 gap-16 md:gap-24 items-center">
                    {/* Bagian Teks */}
                    <motion.div className="text-center md:text-left" variants={itemVariants}>
                        <h3 className="text-3xl md:text-4xl font-semibold font-heading mb-6 leading-relaxed">
                            Experience Authentic Bali
                        </h3>
                        <p className="text-lg md:text-xl text-bali-text-dark leading-relaxed mb-8">
                            Bali, "Island of the Gods", is a tropical paradise with a unique blend of spiritual heritage, stunning natural beauty, and warm hospitality. Our curated journeys allow you to delve deep into its mystical temples, vibrant arts scene, and serene natural wonders.
                        </p>
                        <p className="text-lg md:text-xl text-bali-text-dark leading-relaxed mb-10">
                            Whether you seek thrilling adventures, peaceful retreats, or cultural immersion, Bali offers an unparalleled experience. Let us craft your perfect itinerary.
                        </p>
                        {/* Tombol Explore Our Packages: Mengarahkan ke section Discover */}
                        <Link href="#discover" scroll={false} className="btn-primary"
                            // Menggunakan onClick untuk memastikan smooth scroll ke Discover section
                            onClick={(e) => { e.preventDefault(); document.getElementById('discover')?.scrollIntoView({ behavior: 'smooth' }); }}>
                            Explore Our Packages
                        </Link>
                    </motion.div>

                    {/* Galeri Gambar dengan Efek Overlapping dan Animasi */}
                    <div className="relative w-full aspect-[4/3] md:aspect-auto h-[400px] md:h-[500px] flex justify-center items-center">
                        {/* Gambar Pertama */}
                        <motion.div
                            className="absolute w-[70%] h-[80%] md:w-[60%] md:h-[70%] top-0 left-0 shadow-2xl rounded-3xl overflow-hidden cursor-pointer"
                            variants={imageEntryVariants} // Menerapkan animasi masuk yang ditingkatkan
                            transition={{ delay: 0.2 }}
                            whileHover={{ scale: 1.08, rotate: -2, zIndex: 10, transition: { duration: 0.3 } }} // Efek hover Framer Motion
                        >
                            <Image src="/images/tanah-lot.jpg" alt="Tanah Lot Temple" fill className="object-cover" sizes="(max-width: 768px) 100vw, 50vw" />
                        </motion.div>
                        {/* Gambar Kedua */}
                        <motion.div
                            className="absolute w-[70%] h-[80%] md:w-[60%] md:h-[70%] bottom-0 right-0 shadow-2xl rounded-3xl overflow-hidden cursor-pointer"
                            variants={imageEntryVariants} // Menerapkan animasi masuk yang ditingkatkan
                            transition={{ delay: 0.4 }}
                            whileHover={{ scale: 1.08, rotate: 2, zIndex: 10, transition: { duration: 0.3 } }} // Efek hover Framer Motion
                        >
                            <Image src="/images/uluwatu.jpg" alt="Uluwatu Temple" fill className="object-cover" sizes="(max-width: 768px) 100vw, 50vw" />
                        </motion.div>
                        {/* Overlay dekoratif */}
                        <div className="absolute inset-0 border-4 border-bali-accent rounded-3xl opacity-20 transform rotate-3 scale-105 pointer-events-none"></div>
                    </div>
                </div>

                {/* Bagian Fakta/Statistik Unggulan */}
                <div className="mt-20 md:mt-32 w-full grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-10 text-center relative z-10">
                    <motion.div
                        className="bg-bali-primary p-8 rounded-xl shadow-xl text-bali-light transform hover:scale-105 transition-transform duration-300"
                        variants={itemVariants}
                    >
                        <h3 className="text-5xl font-bold font-heading mb-2 text-bali-accent">300+</h3>
                        <p className="text-lg font-semibold text-bali-light">Exquisite Destinations</p>
                    </motion.div>
                    <motion.div
                        className="bg-bali-primary p-8 rounded-xl shadow-xl text-bali-light transform hover:scale-105 transition-transform duration-300"
                        variants={itemVariants}
                    >
                        <h3 className="text-5xl font-bold font-heading mb-2 text-bali-accent">5000+</h3>
                        <p className="text-lg font-semibold text-bali-light">Delighted Travelers</p>
                    </motion.div>
                    <motion.div
                        className="bg-bali-primary p-8 rounded-xl shadow-xl text-bali-light transform hover:scale-105 transition-transform duration-300"
                        variants={itemVariants}
                    >
                        <h3 className="text-5xl font-bold font-heading mb-2 text-bali-accent">10+</h3>
                        <p className="text-lg font-semibold text-bali-light">Years of Expertise</p>
                    </motion.div>
                </div>
            </div>
        </motion.section>
    );
};

export default About;