// app/page.tsx

// Mengimpor komponen-komponen yang telah kita buat.
// Next.js App Router secara otomatis menangani rendering Server Components
// dan Client Components ('use client') yang diimpor di sini.
import Header from '../components/Header';
import Hero from '../components/Hero';
import About from '../components/About';
import Discover from '../components/Discover';
import Testimonials from '../components/Testimonials';
import Contact from '../components/Contact';
import Footer from '../components/Footer';

// Komponen `Home` ini adalah Server Component secara default di Next.js App Router.
// Ini berarti kode untuk merender struktur dasar halaman ini dijalankan di server
// sebelum dikirim ke browser pengguna.
export default function Home() {
  return (
    <>
      {/* Header adalah Client Component karena mengandung interaktivitas (state, event listeners)
          seperti menu mobile dan efek perubahan warna saat scroll.
          Meskipun Client Component, Next.js akan melakukan Server-Side Rendering (SSR)
          untuk tampilan awalnya, lalu "menghidrasi" (menambahkan interaktivitas) di sisi klien. */}
      <Header />

      {/* Tag <main> digunakan untuk membungkus konten utama yang unik dari halaman.
          Ini penting untuk semantik HTML dan SEO. */}
      <main>
        {/* Section Hero: Bagian pembuka halaman dengan latar belakang gambar besar
            dan teks menarik, dirancang untuk menarik perhatian pengguna. */}
        <Hero />

        {/* Section About: Menyediakan informasi lebih lanjut tentang layanan atau destinasi utama.
            Di sini, kita memperkenalkan detail tentang Bali dengan layout yang lebih kompleks
            dan fakta-fakta penting. */}
        <About />

        {/* Section Discover: Menampilkan daftar tempat-tempat menarik atau paket perjalanan.
            Menggunakan grid kartu dengan efek hover dan animasi saat masuk viewport. */}
        <Discover />

        {/* Section Testimonials: Membangun kepercayaan dengan menampilkan ulasan dari pelanggan yang puas.
            Desainnya lebih menonjolkan kutipan dan informasi pemberi ulasan. */}
        <Testimonials />

        {/* Section Contact: Bagian Call to Action (CTA) yang kuat, mendorong pengguna
            untuk menghubungi atau mengambil langkah selanjutnya. */}
        <Contact />
      </main>

      {/* Footer: Bagian penutup halaman yang berisi informasi kontak,
          link cepat, dan hak cipta. Diletakkan di luar tag <main>
          karena secara semantik mewakili bagian penutup halaman keseluruhan,
          bukan konten utama. */}
      <Footer />
    </>
  );
}