import type { Metadata } from 'next';
import { Inter } from 'next/font/google'; // Contoh: jika kamu ingin pakai font Inter

import './globals.css'; // Global CSS diimpor di sini

const inter = Inter({ subsets: ['latin'] });

export const metadata: Metadata = {
  title: 'Travel Agent - Explore Beautiful Islands',
  description: 'Discover the best beautiful islands and attractive places with our travel agent services.',
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={inter.className}>
        {children}
      </body>
    </html>
  );
}